<?php

/**
 * 购买赛车商城道具
 */

namespace Game\Controller\Shop\ShopCar;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Shop\ShopCarLogic;
use Game\Protobuf\CGBuyShopCar;
use Game\Protobuf\GCBuyShopCar;
use Game\Protobuf\PacketId;

class CG_BuyShopCar extends ControllerBase
{
    use ShopCarLogic;

    private GCBuyShopCar $sendMessage;

    public function __construct()
    {
        $this->message = new CGBuyShopCar();
        $this->sendMessage = new GCBuyShopCar();
    }

    public function run(): int
    {
        $this->sendMessage->setCode(
            $this->buyShopCarItem(
                $this->message->getId(),
                $this->message->getCouponId(),
                $this->message->getParams()
            )
        );
        SendMessage::getInstance()->sendClient(PacketId::GC_BuyShopCar, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
