<?php

/**
 * 兑换抽奖券
 */

namespace Game\Controller\Shop\ShopBlindBox;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Shop\ShopBlindBoxLogic;
use Game\Protobuf\CGExchangeTreasureTicket;
use Game\Protobuf\GCExchangeTreasureTicket;
use Game\Protobuf\PacketId;

class CG_ExchangeTreasureTicket extends ControllerBase
{
    use ShopBlindBoxLogic;

    private GCExchangeTreasureTicket $sendMessage;

    public function __construct()
    {
        $this->message = new CGExchangeTreasureTicket();
        $this->sendMessage = new GCExchangeTreasureTicket();
    }

    public function run(): int
    {
        $this->sendMessage->setCode(
            $this->exchangeTreasureTicket(
                $this->message->getNum()
            )
        );
        SendMessage::getInstance()->sendClient(PacketId::GC_ExchangeTreasureTicket, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
