<?php

/**
 * 获取抽奖次数
 */

namespace Game\Controller\Shop\ShopBlindBox;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Shop\ShopBlindBoxLogic;
use Game\Protobuf\CGBlindBoxNum;
use Game\Protobuf\GCBlindBoxNum;
use Game\Protobuf\PacketId;

class CG_BlindBoxNum extends ControllerBase
{
    use ShopBlindBoxLogic;

    private GCBlindBoxNum $sendMessage;

    public function __construct()
    {
        $this->message = new CGBlindBoxNum();
        $this->sendMessage = new GCBlindBoxNum();
    }

    public function run(): int
    {
        $this->sendMessage->setNum(
            $this->getDrawNum(
                $this->message->getId()
            )
        );
        $this->sendMessage->setId($this->message->getId());
        SendMessage::getInstance()->sendClient(PacketId::GC_BlindBoxNum, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
