<?php

/**
 * 抽奖
 */

namespace Game\Controller\Shop\ShopBlindBox;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Logic\Shop\ShopBlindBoxLogic;
use Game\Protobuf\CGBlindBox;
use Game\Protobuf\GCBlindBox;
use Game\Protobuf\PacketId;

class CG_BlindBox extends ControllerBase
{
    use ShopBlindBoxLogic;

    private GCBlindBox $sendMessage;

    private const DRAW_OPTION_ONE = 1;  //单抽
    private const DRAW_OPTION_TEN = 2;  //10连抽
    //抽取次数
    private const DRAW_NUM_ONE = 1;
    private const DRAW_NUM_TEM = 10;


    public function __construct()
    {
        $this->message = new CGBlindBox();
        $this->sendMessage = new GCBlindBox();
    }

    public function run(): int
    {
        switch ($this->message->getType())
        {
            case self::DRAW_OPTION_ONE:
                $num = self::DRAW_NUM_ONE;
                break;
            case self::DRAW_OPTION_TEN:
                $num = self::DRAW_NUM_TEM;
                break;
            default:
                $this->sendMessage->setCode(ClientErrorCode::SHOP_BUY_NUM_ERROR);
                $this->sendMessage->setId($this->message->getId());
                SendMessage::getInstance()->sendClient(PacketId::GC_BlindBox, $this->sendMessage);
                return ErrorDefine::SUCCESS;
        }
        $code = $this->checkDrawBlindBox($this->message->getId(), $num);
        if ($code == ClientErrorCode::CLIENT_SUCCESS) {
            //开始抽奖
            [$drawNum, $reward] = $this->drawBlindBox($this->message->getId(), $num);
            $this->sendMessage->setCode($code);
            $this->sendMessage->setNum($drawNum);
            $this->sendMessage->setReward($reward);
            $this->sendMessage->setId($this->message->getId());
            SendMessage::getInstance()->sendClient(PacketId::GC_BlindBox, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }
        $this->sendMessage->setCode($code);
        $this->sendMessage->setId($this->message->getId());
        SendMessage::getInstance()->sendClient(PacketId::GC_BlindBox, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}