<?php

/**
 * 服务器
 */

namespace Game\Controller\Server;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Config\GameConfig;
use Game\Constant\ClientErrorCode;
use Game\Protobuf\CGGetServerState;
use Game\Protobuf\GCGetServerState;
use Game\Protobuf\PacketId;
use Game\Logic\CommonConstLogic;
use Tool\InitServer\Config;
use Zone\Zone_2;

class Server extends ControllerBase
{
    use CommonConstLogic;
    private GCGetServerState $sendMessage;

    public function __construct()
    {
        $this->message = new CGGetServerState();
        $this->sendMessage = new GCGetServerState();
    }

    public function run(): int
    {
        $result = $this->getCommonConstData();
        if(!isset($result[Config::SERVER_STATE_KEY])) {
            $this->sendMessage->setCode(ClientErrorCode::SERVER_STATE_SEARCH_NOT_FOUND_ERROR);
        } else {
            $time_str = GameConfig::getInstance()->OPEN_SERVER_TIME();
            $time_s = strtotime($time_str);
            $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
            $this->sendMessage->setStartTime($time_s);
            $this->sendMessage->setState((int)$result[Config::SERVER_STATE_KEY]);
        }
        SendMessage::getInstance()->sendClient(PacketId::GC_GetServerState, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
