<?php

/**
 * 模块状态
 */

namespace Game\Controller\Server;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Protobuf\CGFindCloseModule;
use Game\Protobuf\GCSyncCloseModule;
use Game\Protobuf\PacketId;
use Game\Logic\CommonConstLogic;
use Tool\InitServer\Config;

class ModuleState extends ControllerBase
{
    use CommonConstLogic;
    private GCSyncCloseModule $sendMessage;

    public function __construct()
    {
        $this->message = new CGFindCloseModule();
        $this->sendMessage = new GCSyncCloseModule();
    }

    public function run(): int
    {
        $result = $this->getCommonConstData();
        $module = [];
        if(isset($result[Config::SERVER_MODULE_KEY])) {
            $module = json_decode($result[Config::SERVER_MODULE_KEY], true);
        }
        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMessage->setCloseModuleID($module);
        SendMessage::getInstance()->sendClient(PacketId::GC_SyncCloseModule, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
