<?php

/**
 * 领取赛季循环奖励
 */

namespace Game\Controller\Season;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Logic\PaiweiLevelLogic;
use Game\Model\PaiweiLevelModel;
use Game\Protobuf\CGReceiveSeasonLoop;
use Game\Protobuf\GCFindSeasonReward;
use Game\Protobuf\PacketId;

class ReceiveLoop extends ControllerBase
{
    use PaiweiLevelLogic;
    private GCFindSeasonReward $sendMsg;
    public function __construct()
    {
        $this->message = new CGReceiveSeasonLoop();
        $this->sendMsg = new GCFindSeasonReward();
    }

    public function run(): int
    {

        /**
         * @var PaiweiLevelModel $pwModel
         */
        $pwModel = ModelManager::getInstance()->getModel(ModelTypeDefine::PAIWEI_LEVEL);
        $pwModel->receiveLoopReward();
        $pwModel->searchLevelData();
        $this->sendMsg->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMsg->setScore($pwModel->data->seasonScore);
        $this->sendMsg->setReward($pwModel->data->seasonReward);
        $this->sendMsg->setOverFlowExp($pwModel->data->overFlowExp);
        $this->sendMsg->setHaveNum($pwModel->data->haveRewardNum);
        $this->sendMsg->setNum($pwModel->data->rewardNum);
        SendMessage::getInstance()->sendClient(PacketId::GC_FindSeasonReward, $this->sendMsg);
        return ErrorDefine::SUCCESS;
    }

}