<?php

/**
 * 领取赛季奖励
 */

namespace Game\Controller\Season;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Game\Constant\ModelTypeDefine;
use Game\Logic\PaiweiLevelLogic;
use Game\Model\PaiweiLevelModel;
use Game\Protobuf\CGReceiveSeasonReward;

class Receive extends ControllerBase
{
    use PaiweiLevelLogic;

    public function __construct()
    {
        $this->message = new CGReceiveSeasonReward();
    }

    public function run(): int
    {
        $tplID = $this->message->getTplID();
        $fastReward = $this->message->getFastReward();

        /**
         * @var PaiweiLevelModel $pwModel
         */
        $pwModel = ModelManager::getInstance()->getModel(ModelTypeDefine::PAIWEI_LEVEL);
        $pwModel->searchLevelData();

        if(!$fastReward) {
            $pwModel->receive($tplID);
        } else {
            $pwModel->fastReceive();
        }
        return ErrorDefine::SUCCESS;
    }

}