<?php
/**
 * 获取赛季奖励信息
 */
namespace Game\Controller\Season;
use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Model\PaiweiLevelModel;
use Game\Protobuf\CGFindSeasonReward;
use Game\Protobuf\GCFindSeasonReward;
use Game\Protobuf\PacketId;

class FindReward extends ControllerBase
{
    private GCFindSeasonReward $sendMsg;
    public function __construct()
    {
        $this->message = new CGFindSeasonReward();
        $this->sendMsg = new GCFindSeasonReward();
    }

    public function run(): int
    {
        /**
         * @var PaiweiLevelModel $pwModel
         */
        $pwModel = ModelManager::getInstance()->getModel(ModelTypeDefine::PAIWEI_LEVEL);
        $pwModel->searchLevelData();
        $this->sendMsg->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMsg->setScore($pwModel->data->seasonScore);
        $this->sendMsg->setReward($pwModel->data->seasonReward);
        $this->sendMsg->setOverFlowExp($pwModel->data->overFlowExp);
        $this->sendMsg->setHaveNum($pwModel->data->haveRewardNum);
        $this->sendMsg->setNum($pwModel->data->rewardNum);
        SendMessage::getInstance()->sendClient(PacketId::GC_FindSeasonReward, $this->sendMsg);
        return ErrorDefine::SUCCESS;
    }
}