<?php

/**
 * desc 同步房间时间
 */

namespace Game\Controller\RoomCustomize;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\TemplateDefine;
use Game\Logic\RoomCustomize\RoomLogic;
use Game\Protobuf\CGSyncCRoomLimitTime;
use Game\Logic\Pvp\PvpLogic;
use Game\Protobuf\GCSyncCRoomLimitTime;
use Game\Protobuf\PacketId;

class SyncRoomTime extends ControllerBase {
    use RoomLogic;
    use PvpLogic;
    public function __construct() {
        $this->message = new CGSyncCRoomLimitTime();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();
        // 房间失效时间
        $timeout1 = $this->getTerm(TemplateDefine::TYPE_CONST,
            TemplateConst::Const_CRoom_Timeout2, "Const_num");
        // 解散房间提醒倒计时
        $timeout2 = $this->getTerm(TemplateDefine::TYPE_CONST,
            TemplateConst::Const_CRoom_Timeout3, "Const_num");
        // 冗余时间
        $timeout3 = 10;
        $changeTime = $timeout1 + $timeout2 + $timeout3;
        if(!$this->changeRoomExpireTime($roomID, $changeTime)) {
            return ErrorDefine::ERROR_INTERNAL;
        }
        $sendMsg = new GCSyncCRoomLimitTime();
        $sendMsg->setCode(0);
        SendMessage::getInstance()->sendClient(PacketId::GC_SyncCRoomLimitTime, $sendMsg);

        return ErrorDefine::SUCCESS;
    }
}