<?php

/**
 * desc 收藏地图
 */

namespace Game\Controller\RoomCustomize;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\RoomCustomize\RoomInfoLogic;
use Game\Protobuf\CGSaveMapID;

class SaveMapID extends ControllerBase {
    use RoomInfoLogic;
    public function __construct() {
        $this->message = new CGSaveMapID();
    }

    public function run(): int {
        $mapID = $this->message->getMapID();
        $option = $this->message->getOption();

        if(!$this->saveMapID($mapID, $option)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}