<?php

/**
 * desc 房主解散房间
 */

namespace Game\Controller\RoomCustomize;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\RoomCustomize\RoomLogic;
use Game\Protobuf\CGRemoveCRoomByRoomID;
use Game\Protobuf\GCRemoveCRoomByRoomID;
use Game\Protobuf\GCSyncCRoomLimitTime;
use Game\Protobuf\PacketId;

class RemoveRoomByRoomID extends ControllerBase {
    use RoomLogic;
    public function __construct() {
        $this->message = new CGRemoveCRoomByRoomID();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();

        if(!$this->RemoveRoomAllPlayer($roomID)) {
            return ErrorDefine::ERROR_INTERNAL;
        }
        $sendMsg = new GCRemoveCRoomByRoomID();
        $sendMsg->setCode(0);
        SendMessage::getInstance()->sendClient(PacketId::GC_RemoveCRoomByRoomID, $sendMsg);
        return ErrorDefine::SUCCESS;
    }
}