<?php

/**
 * desc 通过roomID加入房间观战
 */

namespace Game\Controller\RoomCustomize;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\RoomCustomize\RoomLogic;
use Game\Protobuf\CGWatchByCRoomID;

class JoinWatchByRoomID extends ControllerBase {
    use RoomLogic;
    public function __construct() {
        $this->message = new CGWatchByCRoomID();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();
        $password = $this->message->getPassword();
        if(!$this->joinWatchByRoomID($roomID, $password)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}