<?php

/**
 * desc 通过roomID加入房间
 */

namespace Game\Controller\RoomCustomize;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\RoomCustomize\RoomLogic;
use Game\Protobuf\CGJoinByCRoomID;

class JoinByRoomID extends ControllerBase {
    use RoomLogic;
    public function __construct() {
        $this->message = new CGJoinByCRoomID();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();
        $password = $this->message->getPassword();
        $isJoin = $this->message->getIsJoin();
        if(!$this->joinRoomByRoomID($roomID, $password, $isJoin, $this->message->getInviterPlayerId())) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}