<?php

/**
 * desc 获取自定义房间列表
 */

namespace Game\Controller\RoomCustomize;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\RoomCustomize\RoomLogic;
use Game\Protobuf\CGGetCustomize;

class GetCustomize extends ControllerBase {
    use RoomLogic;
    public function __construct() {
        $this->message = new CGGetCustomize();
    }

    public function run(): int {
        $page = $this->message->getPage();

        if(!$this->getCustomizeList($page)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}