<?php

/**
 * desc 退出房间
 */

namespace Game\Controller\RoomCustomize;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\RoomCustomize\RoomLogic;
use Game\Protobuf\CGExitCRoom;

class ExitRoom extends ControllerBase {
    use RoomLogic;
    public function __construct() {
        $this->message = new CGExitCRoom();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();
        if(!$this->exitRoom($roomID)) {
            return ErrorDefine::ERROR_INTERNAL;
        }
        return ErrorDefine::SUCCESS;
    }
}