<?php

/**
 * desc 新建房间
 */

namespace Game\Controller\RoomCustomize;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\RoomCustomize\RoomLogic;
use Game\Protobuf\CGCreateCRoom;

class CreateRoom extends ControllerBase {

    use RoomLogic;
    public function __construct() {
        $this->message = new CGCreateCRoom();
    }

    public function run(): int {
        $mapID = $this->message->getMapID();
        $modeType = $this->message->getModeType();
        $roomName = $this->message->getRoomName();
        $password = $this->message->getPassword();

        if(!$this->createRoom($mapID, $modeType, $roomName, $password)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}