<?php

/**
 * desc 修改房间状态
 */

namespace Game\Controller\RoomCustomize;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\RoomCustomize\RoomInfoLogic;
use Game\Protobuf\CGUpdateCRoomState;

class ChangeRoomState extends ControllerBase {
    use RoomInfoLogic;
    public function __construct() {
        $this->message = new CGUpdateCRoomState();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();
        $state = $this->message->getState();

        if(!$this->updateRoomState($roomID, $state)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}