<?php

/**
 * desc 修改房间密码
 */

namespace Game\Controller\RoomCustomize;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\RoomCustomize\RoomInfoLogic;
use Game\Protobuf\CGUpdateCRoomPWD;

class ChangeRoomPassword extends ControllerBase {
    use RoomInfoLogic;
    public function __construct() {
        $this->message = new CGUpdateCRoomPWD();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();
        $password = $this->message->getPassword();

        if(!$this->updateRoomPwd($roomID, $password)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}