<?php

/**
 * desc 修改房间密码是否可见
 */

namespace Game\Controller\RoomCustomize;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\RoomCustomize\RoomInfoLogic;
use Game\Protobuf\CGPasswordIsShow;

class ChangeRoomIsShowPwd extends ControllerBase {
    use RoomInfoLogic;
    public function __construct() {
        $this->message = new CGPasswordIsShow();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();
        $state = $this->message->getIsShow();

        if(!$this->updateRoomIsShowPwd($roomID, $state)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}