<?php

/**
 * desc 修改房间AI
 */

namespace Game\Controller\RoomCustomize;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\RoomCustomize\RoomInfoLogic;
use Game\Protobuf\CGUpdateCRoomAI;

class ChangeRoomAI extends ControllerBase {
    use RoomInfoLogic;
    public function __construct() {
        $this->message = new CGUpdateCRoomAI();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();
        $ai = $this->message->getAI();

        if(!$this->updateRoomAI($roomID, $ai)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}