<?php

/**
 * desc 修改房间内玩家位置
 */

namespace Game\Controller\RoomCustomize;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\RoomCustomize\RoomInfoLogic;
use Game\Protobuf\CGUpdatePlayerTeam;

class ChangePlayerTeam extends ControllerBase {
    use RoomInfoLogic;
    public function __construct() {
        $this->message = new CGUpdatePlayerTeam();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();
        $team = $this->message->getTeam();
        if(!$this->updatePlayerTeam($roomID, $team)) {
            return ErrorDefine::ERROR_INTERNAL;
        }
        return ErrorDefine::SUCCESS;
    }
}