<?php

/**
 * desc 修改房间内玩家车辆
 */

namespace Game\Controller\RoomCustomize;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\RoomCustomize\RoomInfoLogic;
use Game\Protobuf\CGChangeCRoomPlayerCar;

class ChangePlayerCar extends ControllerBase {
    use RoomInfoLogic;
    public function __construct() {
        $this->message = new CGChangeCRoomPlayerCar();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();
        $carID  = $this->message->getCarTplID();
        $carUID = $this->message->getCarUid();
        if(!$this->updatePlayerCar($roomID, $carID, $carUID)) {
            return ErrorDefine::ERROR_INTERNAL;
        }
        return ErrorDefine::SUCCESS;
    }
}