<?php

/**
 * desc 修改房间地图
 */

namespace Game\Controller\RoomCustomize;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\RoomCustomize\RoomInfoLogic;
use Game\Protobuf\CGUpdateCRoomMapID;

class ChangeMapID extends ControllerBase {
    use RoomInfoLogic;
    public function __construct() {
        $this->message = new CGUpdateCRoomMapID();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();
        $mapID = $this->message->getMapID();

        if(!$this->updateRoomMap($roomID, $mapID)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}