<?php

/**
 * desc 修改团队排位准备界面玩家状态
 */

namespace Game\Controller\Room;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Room\RoomInfoLogic;
use Game\Protobuf\CGRankReadyState;

class RankUpdateState extends ControllerBase {
    use RoomInfoLogic;
    public function __construct() {
        $this->message = new CGRankReadyState();
    }

    public function run(): int {
        if(!$this->changePlayerState(
            $this->message->getState(),
            $this->message->getPlayers(),
            $this->message->getAIId()))
        {
            return ErrorDefine::ERROR_INTERNAL;
        }
        return ErrorDefine::SUCCESS;
    }
}