<?php

/**
 * desc 排位准备阶段换车改装
 */

namespace Game\Controller\Room;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Room\RoomInfoLogic;
use Game\Protobuf\CGRankChangeCar;
use Game\Protobuf\CGRankChangeCarExteriorRefit;

class RankUpdateCarExteriorRefit extends ControllerBase {
    use RoomInfoLogic;
    public function __construct() {
        $this->message = new CGRankChangeCarExteriorRefit();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();
        $players  = $this->message->getPlayers();
        if(!$this->rankReplaceCarExteriorRefit($roomID, $players)) {
            return ErrorDefine::ERROR_INTERNAL;
        }
        return ErrorDefine::SUCCESS;
    }
}