<?php

/**
 * desc 排位准备阶段换车
 */

namespace Game\Controller\Room;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Room\RoomInfoLogic;
use Game\Protobuf\CGRankChangeCar;

class RankUpdateCar extends ControllerBase {
    use RoomInfoLogic;
    public function __construct() {
        $this->message = new CGRankChangeCar();
    }

    public function run(): int {
        $tplID = $this->message->getCarTplID();
        $carUID = $this->message->getCarUid();
        $roomID = $this->message->getRoomID();
        $players  = $this->message->getPlayers();
        if(!$this->rankReplaceCar($roomID, $tplID, $carUID, $players)) {
            return ErrorDefine::ERROR_INTERNAL;
        }
        return ErrorDefine::SUCCESS;
    }
}