<?php

/**
 * desc 团队排位准备界面进入游戏同步
 */

namespace Game\Controller\Room;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Room\RoomInfoLogic;
use Game\Protobuf\CGRankJoinScene;

class RankEnterScene extends ControllerBase
{
    use RoomInfoLogic;

    public function __construct()
    {
        $this->message = new CGRankJoinScene();
    }

    public function run(): int
    {
        $players = $this->message->getPlayers();
        if (!$this->enterScene($players)) {
            return ErrorDefine::ERROR_INTERNAL;
        }
        return ErrorDefine::SUCCESS;
    }
}

