<?php
/**
 * 房主踢人
 */
namespace Game\Controller\Room;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Room\RoomLogic;
use Game\Protobuf\CGOwnerRemovePlayer;

class OwnerRemovePlayer extends ControllerBase {
    use RoomLogic;
    public function __construct() {
        $this->message = new CGOwnerRemovePlayer();
    }
    public function run(): int {
        $roomID = $this->message->getRoomID();
        $playerID = $this->message->getPlayerID();

        if(!$this->removePlayerByRoomID($roomID, $playerID)) {
            return ErrorDefine::ERROR_INTERNAL;
        }
        return ErrorDefine::SUCCESS;
    }
}
