<?php

/**
 * desc 通过roomID加入房间
 */

namespace Game\Controller\Room;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Room\RoomLogic;
use Game\Protobuf\CGJoinByRoomID;

class JoinByRoomID extends ControllerBase {
    use RoomLogic;
    public function __construct() {
        $this->message = new CGJoinByRoomID();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();

        if(!$this->joinRoomByRoomID($roomID, $this->message->getInviterPlayerId())) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}