<?php

/**
 * desc 聊天查询房间
 */

namespace Game\Controller\Room;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Logic\Room\RoomLogic;
use Game\Protobuf\CGFindIMRoomList;
use Game\Protobuf\GCFindIMRoomList;
use Game\Protobuf\PacketId;

class IMFindRoomList extends ControllerBase {

    use RoomLogic;
    public GCFindIMRoomList $sendMessage;
    public function __construct() {
        $this->message = new CGFindIMRoomList();
        $this->sendMessage = new GCFindIMRoomList();
    }

    public function run(): int {
        $page = $this->message->getPage();
        $rooms = [];
        if(!$this->IMFindRoomList($page, $rooms)) {
            $this->sendMsg(ClientErrorCode::CLIENT_SUCCESS, $rooms);
            return ErrorDefine::ERROR_INTERNAL;
        }
        $this->sendMsg(ClientErrorCode::CLIENT_SUCCESS, $rooms);
        return ErrorDefine::SUCCESS;
    }

    private function sendMsg($code, $rooms) {
        $this->sendMessage->setCode($code);
        $this->sendMessage->setRooms($rooms);
        SendMessage::getInstance()->sendClient(PacketId::GC_FindIMRoomList, $this->sendMessage);
    }
}