<?php

/**
 * desc 快速加入房间
 */

namespace Game\Controller\Room;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Room\RoomLogic;
use Game\Protobuf\CGFastJoinRoom;

class FastJoin extends ControllerBase {
    use RoomLogic;
    public function __construct() {
        $this->message = new CGFastJoinRoom();
    }

    public function run(): int {
        $modeType = $this->message->getModeType();
        $roomName = $this->message->getRoomName();

        if(!$this->fastJoinRoom($modeType, $roomName)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}