<?php

/**
 * desc 退出房间
 */

namespace Game\Controller\Room;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Room\RoomLogic;
use Game\Protobuf\CGExitRoom;

class ExitRoom extends ControllerBase {
    use RoomLogic;
    public function __construct() {
        $this->message = new CGExitRoom();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();
        if(!$this->exitRoom($roomID)) {
            return ErrorDefine::ERROR_INTERNAL;
        }
        return ErrorDefine::SUCCESS;
    }
}