<?php

/**
 * desc 新建房间
 */

namespace Game\Controller\Room;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Room\RoomLogic;
use Game\Protobuf\CGCreateRoom;

class CreateRoom extends ControllerBase {

    use RoomLogic;
    public function __construct() {
        $this->message = new CGCreateRoom();
    }

    public function run(): int {
        $mapID = $this->message->getMapID();
        $modeType = $this->message->getModeType();
        $roomName = $this->message->getRoomName();

        if(!$this->createRoom($mapID, $modeType, $roomName)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}