<?php

/**
 * desc 修改房间状态
 */

namespace Game\Controller\Room;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Room\RoomInfoLogic;
use Game\Protobuf\CGUpdateRoomState;

class ChangeRoomState extends ControllerBase {
    use RoomInfoLogic;
    public function __construct() {
        $this->message = new CGUpdateRoomState();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();
        $state = $this->message->getState();

        if(!$this->updateRoomState($roomID, $state)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}