<?php

/**
 * desc 修改房间内玩家状态
 */

namespace Game\Controller\Room;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Room\RoomInfoLogic;
use Game\Protobuf\CGUpdatePlayerState;

class ChangePlayerState extends ControllerBase {
    use RoomInfoLogic;
    public function __construct() {
        $this->message = new CGUpdatePlayerState();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();
        $state  = $this->message->getState();
        if(!$this->updatePlayerState($roomID, $state)) {
            return ErrorDefine::ERROR_INTERNAL;
        }
        return ErrorDefine::SUCCESS;
    }
}