<?php

/**
 * desc 修改房间内玩家车辆
 */

namespace Game\Controller\Room;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Room\RoomInfoLogic;
use Game\Protobuf\CGUpdatePlayerCar;

class ChangePlayerCar extends ControllerBase {
    use RoomInfoLogic;
    public function __construct() {
        $this->message = new CGUpdatePlayerCar();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();
        $carID  = $this->message->getCarTplID();
        $carUID = $this->message->getCarUid();
        if(!$this->updatePlayerCar($roomID, $carID, $carUID)) {
            return ErrorDefine::ERROR_INTERNAL;
        }
        return ErrorDefine::SUCCESS;
    }
}