<?php

/**
 * desc 修改房间名称
 */

namespace Game\Controller\Room;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Room\RoomInfoLogic;
use Game\Protobuf\CGUpdateRoomName;

class ChangeName extends ControllerBase {
    use RoomInfoLogic;
    public function __construct() {
        $this->message = new CGUpdateRoomName();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();
        $roomName = $this->message->getRoomName();

        if(!$this->updateRoomName($roomID, $roomName)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}