<?php

/**
 * desc 修改房间模式
 */

namespace Game\Controller\Room;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Room\RoomInfoLogic;
use Game\Protobuf\CGUpdateRoomModeType;

class ChangeModeType extends ControllerBase {
    use RoomInfoLogic;
    public function __construct() {
        $this->message = new CGUpdateRoomModeType();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();
        $modeType = $this->message->getModeType();

        if(!$this->updateRoomMode($roomID, $modeType)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}