<?php

/**
 * desc 修改房间地图
 */

namespace Game\Controller\Room;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\Room\RoomInfoLogic;
use Game\Protobuf\CGUpdateRoomMapID;

class ChangeMapID extends ControllerBase {
    use RoomInfoLogic;
    public function __construct() {
        $this->message = new CGUpdateRoomMapID();
    }

    public function run(): int {
        $roomID = $this->message->getRoomID();
        $mapID = $this->message->getMapID();

        if(!$this->updateRoomMap($roomID, $mapID)) {
            return ErrorDefine::ERROR_INTERNAL;
        }

        return ErrorDefine::SUCCESS;
    }
}