<?php

/**
 * 比赛结束后,广播聊天消息
 * 只广播,不校验
 */

namespace Game\Controller\Room;

use Framework\Define\ErrorDefine;
use Framework\Logic\PacketCacheLogic;
use Framework\MVC\ControllerBase;
use Game\Logic\GenerateAiLogic;
use Game\Protobuf\CGBroadcastChat;
use Game\Protobuf\GCBroadcastChat;
use Game\Protobuf\PacketId;

class CG_BroadcastChat extends ControllerBase
{
    use PacketCacheLogic;
    use GenerateAiLogic;

    private GCBroadcastChat $sendMessage;

    public function __construct()
    {
        $this->message = new CGBroadcastChat();
        $this->sendMessage = new GCBroadcastChat();
    }

    public function run(): int
    {
        $this->sendMessage->setFromPlayerId($this->message->getPlayerId());
        $this->sendMessage->setMatchId($this->message->getMatchId());
        $this->sendMessage->setChatMessage($this->message->getChatMessage());
        $this->sendMessage->setNickname($this->message->getNickname());

        foreach ($this->message->getPlayers() as $pid) {
            if ($this->checkIsAIPlayer($pid)) {
                continue;
            }
            $this->addPacket(
                PacketId::GC_BroadcastChat,
                $this->sendMessage,
                $pid
            );
        }
        return ErrorDefine::SUCCESS;
    }
}
