<?php
/**
 * 排行榜点赞
 * @date 2022/10/19
 * @author leeFx
 **/
namespace Game\Controller\Rank;

use Framework\Define\ErrorDefine;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Logic\RankLogic;
use Game\Protobuf\CGRankLike;
use Game\Protobuf\PacketId;

class Like extends ControllerBase
{
    use RankLogic;
    public function __construct()
    {
        $this->message = new CGRankLike();
    }

    public function run(): int
    {
        $playerID = $this->message->getPlayerID();
        if(!$this->rankLike($playerID)) {
            LogMark::getInstance()->markError(
                ErrorDefine::ERROR_INTERNAL,
                '[rank controller] rank like error!',
                ['playerID' => $playerID]
            );
        }
        return ErrorDefine::SUCCESS;
    }
}