<?php
/**
 * 排行榜
 * @date 2022/10/08
 * @author leeFx
 **/
namespace Game\Controller\Rank;

use Framework\Define\ErrorDefine;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Game\Protobuf\CGFindRank;
use Game\Logic\RankLogic;

class FindRank extends ControllerBase
{
    use RankLogic;
    public function __construct()
    {
        $this->message = new CGFindRank();
    }

    public function run(): int
    {
        $rankType = $this->message->getRankType();
        $mapID = $this->message->getMapID();
        $page = $this->message->getPage();
        if(!$this->findRankData($rankType, $mapID, $page)) {
            LogMark::getInstance()->markError(
                ErrorDefine::ERROR_INTERNAL,
                '[rank controller] find rank data error!',
                ['rankType' => $rankType, 'mapID' => $mapID]
            );
        }
        return ErrorDefine::SUCCESS;
    }
}