<?php
/**
 * 俱乐部全局排行榜
 * @date 2022/7/4
 * @author JZW
 **/
namespace Game\Controller\Rank;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Framework\Logic\RankLogic;
use Game\Constant\ClientErrorCode;
use Game\Logic\Club\ClubLogic;
use Game\Protobuf\CGClubRank;
use Game\Protobuf\GCClubRank;
use Game\Protobuf\PacketId;

class Club extends ControllerBase
{
    use RankLogic;
    use ClubLogic;
    public GCClubRank $sendMessage;

    public function __construct()
    {
        $this->message = new CGClubRank();
        $this->sendMessage = new GCClubRank();
    }

    public function run(): int
    {
        $page = $this->message->getPage();
        $this->getClubPointsRank($lists, $page);

        $clubIds = [];
        foreach ($lists as $clubId => $score){
            $clubIds[] = $clubId;
        }
        $clubData = $this->getClubsData($clubIds);
        $sendData = $this->sendClientData($clubData);
        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMessage->setData($sendData);
        SendMessage::getInstance()->sendClient(PacketId::GC_ClubRank, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}