<?php
namespace Game\Controller\Pvp;
use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Game\Constant\ModelTypeDefine;
use Game\Model\Pvp\PvpBaseModel;
use Game\Protobuf\CGGetPracticeRandMap;

class GetPracticeRandMap extends ControllerBase {
    public function __construct() {
        $this->message = new CGGetPracticeRandMap();
    }

    public function run(): int {
        /**
         * @var PvpBaseModel $pvpBaseModel
         */
        $pvpBaseModel = ModelManager::getInstance()->getModel(ModelTypeDefine::PVP_BASE);
        if(!$pvpBaseModel->getPracticeRandMap()) {
            return ErrorDefine::ERROR_INTERNAL;
        }
        return ErrorDefine::SUCCESS;
    }
}