<?php

/**
 * pvp结算--单机
 */

namespace Game\Controller\Pvp;

use Framework\Define\ErrorDefine;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\GameErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Data\RaceResultData;
use Game\Logic\Pvp\PvpLogic;
use Game\Logic\Pvp\PvpSettlementLogic;
use Game\Protobuf\CGGameFinish;
use Game\Protobuf\PlayerMark;

class FinishPvp extends ControllerBase
{
    use PvpLogic;
    use PvpSettlementLogic;

    public function __construct()
    {
        $this->message = new CGGameFinish();
    }

    public function run(): int
    {
        //参照CLIServer\Model\PVP\PvpPacket 整理格式
        $playerList = array();
        $mapId = null;
        foreach ($this->message->getPlayerList() as $playerMark) {
            /**
             * @var PlayerMark $playerMark
             */
            //整理结算数据
            $raceResult = new RaceResultData();
            $raceResult->_playerId = $playerMark->getPlayerId();
            $raceResult->_carId = $playerMark->getCarId();
            $raceResult->_rank = $playerMark->getRank();
            $raceResult->_costTime = $playerMark->getCostTime();
            $raceResult->_groupId = $playerMark->getGroupID();
            $raceResult->_joinId = $playerMark->getJoinID();
            $raceResult->_modeType = $this->message->getMatchType();
            //解析结算参数
            $this->analysisSettlementParam($playerMark->getSettlementParam(), $raceResult);

            $playerList[$raceResult->_playerId] = $raceResult;
            if ($raceResult->_playerId == $this->playerId) {
                //检查joinId
                $myJoinId = $this->getMyJoinId();
                if ($raceResult->_joinId == 0 || $raceResult->_joinId != $myJoinId) {
                    LogMark::getInstance()->markError(
                        GameErrorCode::PVP_PACKET_ERROR,
                        "[PVPFlowLog][FinishPvp] JoinId not equal",
                        array(
                            "packetJoinId" => $raceResult->_joinId,
                            "MyJoinId" => $myJoinId
                        )
                    );
                    SendMessage::getInstance()->sendErrorClient(ClientErrorCode::PVP_MATCHING_JOIN_ID_ERROR);
                    return ErrorDefine::SUCCESS;
                }
                //查询mapId
                $record = $this->getRecordByJoinId($myJoinId);
                if (is_null($record)) {
                    LogMark::getInstance()->markError(
                        GameErrorCode::PVP_PACKET_ERROR,
                        "[PVPFlowLog][FinishPvp] record not found",
                        array(
                            "MyJoinId" => $myJoinId
                        )
                    );
                    SendMessage::getInstance()->sendErrorClient(ClientErrorCode::RECORD_NOT_FOUND);
                    return ErrorDefine::SUCCESS;
                }
                $mapId = $record->mapID;
            }
        }
        LogMark::getInstance()->markDebug(
            "[PVPFlowLog][19][FinishPvp] single player start matchSettlement",
            $playerList
        );
        if (is_null($mapId)) {
            LogMark::getInstance()->markError(
                GameErrorCode::PVP_PACKET_ERROR,
                "[PVPFlowLog][FinishPvp] mapId not found",
            );
            SendMessage::getInstance()->sendErrorClient(ClientErrorCode::RECORD_NOT_FOUND);
            return ErrorDefine::SUCCESS;
        }
        $breakingRecordInfo = $this->tidySettlementParams($playerList, $this->message->getMatchType(), $mapId);
        $modeModel = ModelManager::getInstance()->getModel(ModelTypeDefine::MODE_MAP[$this->message->getMatchType()]);
        if (false == $modeModel->matchSettlement($playerList, $breakingRecordInfo)) {
            LogMark::getInstance()->markDebug(
                "[PVPFlowLog][FinishPvp] matchSettlement error"
            );
        }
        return ErrorDefine::SUCCESS;
    }
}
