<?php

/**
 * 取消匹配
 */

namespace Game\Controller\Pvp;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Game\Constant\ModelTypeDefine;
use Game\Model\Pvp\PvpBaseModel;
use Game\Protobuf\CGCancelMatch;

class CancelMatch extends ControllerBase
{
    public function __construct()
    {
        $this->message = new CGCancelMatch();
    }

    public function run(): int
    {
        $roomID = $this->message->getRoomID();

        /**
         * @var PvpBaseModel $pvp
         */
        $pvp = ModelManager::getInstance()->getModel(ModelTypeDefine::PVP_BASE);

        // 取消匹配
        $code = $pvp->cancelMatch($roomID);
        if ($code != ErrorDefine::SUCCESS) {
            return $code;
        }

        return ErrorDefine::SUCCESS;
    }
}