<?php

/**
 * pvp结算--破纪录信息
 */

namespace Game\Controller\Pvp;

use Framework\Define\ErrorDefine;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\GameErrorCode;
use Game\Logic\MapStatisticsLogic;
use Game\Logic\Pvp\PvpLogic;
use Game\Protobuf\CGRecordBreakingInfo;
use Game\Protobuf\GCRecordBreakingInfo;
use Game\Protobuf\PacketId;

class CG_RecordBreakingInfo extends ControllerBase
{
    use MapStatisticsLogic;
    use PvpLogic;

    private GCRecordBreakingInfo $sendMessage;

    public function __construct()
    {
        $this->message = new CGRecordBreakingInfo();
        $this->sendMessage = new GCRecordBreakingInfo();
    }

    public function run(): int
    {
        //检查JoinId
        $myJoinId = $this->getMyJoinId();
        if ($this->message->getJoinId() == 0 || $this->message->getJoinId() != $myJoinId) {
            LogMark::getInstance()->markError(
                GameErrorCode::PVP_PACKET_ERROR,
                "[CG_RecordBreakingInfo] JoinId not equal",
                array(
                    "packetJoinId" => $this->message->getJoinId(),
                    "MyJoinId" => $myJoinId
                )
            );
            $this->sendMessage->setCode(ClientErrorCode::PVP_DATA_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_RecordBreakingInfo, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }
        //查询mapId
        $record = $this->getRecordByJoinId($myJoinId);
        if (is_null($record)) {
            LogMark::getInstance()->markError(
                GameErrorCode::PVP_PACKET_ERROR,
                "[PVPFlowLog][FinishPvp] record not found",
                array(
                    "MyJoinId" => $myJoinId
                )
            );
            $this->sendMessage->setCode(ClientErrorCode::PVP_DATA_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_RecordBreakingInfo, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }
        $mapId = $record->mapID;
        $breakingRecordInfo = $this->updateMapStatistics(
            $this->playerId,
            $record->matchType,
            $record->carId,
            $mapId,
            $this->message->getSettlementParam(),
            0,
            false
        );
        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMessage->setMyBreakingInfo($breakingRecordInfo);
        SendMessage::getInstance()->sendClient(PacketId::GC_RecordBreakingInfo, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
