<?php

/**
 * 领取总活跃度奖励
 */

namespace Game\Controller\Proficiency;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Logic\ProficiencyLogic;
use Game\Protobuf\CGGetProficiencyReward;
use Game\Protobuf\GCProficiencyReward;
use Game\Protobuf\PacketId;

class CG_GetProficiencyReward extends ControllerBase
{
    use ProficiencyLogic;

    private GCProficiencyReward $sendMessage;

    public function __construct()
    {
        $this->message = new CGGetProficiencyReward();
        $this->sendMessage = new GCProficiencyReward();
    }

    public function run(): int
    {
        $code = ClientErrorCode::CLIENT_SUCCESS;
        if ($this->message->getOneKey()) {
            //一键领取
            $data = $this->getTotalProficiencyAllReward();
        } else {
            //单个领取
            $data = $this->getTotalProficiencySingleReward($this->message->getId(), $this->message->getIsExpert(), $code);
        }
        $this->sendMessage->setCode($code);
        SendMessage::getInstance()->sendClient(PacketId::GC_ProficiencyReward, $this->sendMessage);
        $this->sendProficiencyDataMessage($data);
        return ErrorDefine::SUCCESS;
    }
}
