<?php

/**
 * 领取赛车活跃度奖励
 */

namespace Game\Controller\Proficiency;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Logic\ProficiencyLogic;
use Game\Protobuf\CGGetCarProficiencyReward;
use Game\Protobuf\GCCarProficiencyReward;
use Game\Protobuf\PacketId;

class CG_GetCarProficiencyReward extends ControllerBase
{
    use ProficiencyLogic;

    private GCCarProficiencyReward $sendMessage;

    public function __construct()
    {
        $this->message = new CGGetCarProficiencyReward();
        $this->sendMessage = new GCCarProficiencyReward();
    }

    public function run(): int
    {
        $code = ClientErrorCode::CLIENT_SUCCESS;
        if ($this->message->getOneKey()) {
            //一键领取
            $data = $this->getCarAllProficiencyReward($this->message->getCarId(), $code);
        } else {
            //单个领取
            $data = $this->getCarSingleProficiencyReward($this->message->getCarId(), $this->message->getLevelId(), $code);
        }
        $this->sendMessage->setCode($code);
        $this->sendMessage->setProficiencyReward($data);
        $this->sendMessage->setCarId($this->message->getCarId());
        SendMessage::getInstance()->sendClient(PacketId::GC_CarProficiencyReward, $this->sendMessage);
        //返回总熟练度信息
        $this->sendProficiencyDataMessage($this->getTotalProficiencyData());
        return ErrorDefine::SUCCESS;
    }
}
